package com.sg.stepdefinition;

import com.sg.driver.CucumberTestRunner;
import com.sg.pages.LoginPage;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.en.And;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import org.testng.Assert;
import static com.sg.driver.CucumberTestRunner.userMethod;

public class UserStepDefinition extends CucumberTestRunner {
    @Given("user navigates the URL")
    public void userNavigatesTheURL(DataTable dataTable) {
        Assert.assertTrue(userMethod.verifyUserNavigatesURL(oBrowser, dataTable));
    }


    @Then("user clicks on Login button")
    public void userClicksOnLoginButton() {
        Assert.assertTrue(appInd.clickObject(oBrowser, LoginPage.obj_Login_Button));
    }

    @And("verify login was successful")
    public void verifyLoginWasSuccessful() {
        Assert.assertTrue(appInd.verifyText(oBrowser, LoginPage.obj_HomePageTitle_Label, "Text", "Enter Time-Track"));
    }

    @Then("user click on logout link")
    public void userClickOnLogoutLink() {
        Assert.assertTrue(appInd.clickObject(oBrowser, LoginPage.obj_Logout_Link));
    }

    @And("verify logout was successful")
    public void verifyLogoutWasSuccessful() {
        Assert.assertTrue(appInd.verifyText(oBrowser, LoginPage.obj_LoginPage_Lable, "Text", "Please identify yourself"));
    }

    @Then("user enter the userName {string}")
    public void userEnterTheUserName(String userName) {
        Assert.assertTrue(userMethod.enterUserName(oBrowser, userName));
    }

    @And("user enter the password {string}")
    public void userEnterThePassword(String password) {
        Assert.assertTrue(userMethod.enterPassword(oBrowser, password));
    }
}
